#!/bin/sh

VER=0.4.5
TARGET=midori-$VER
TARGETBALL=$TARGET.tar.bz2
TARGETDIR=$TARGET

. ./_xfceset.sh

echo $TARGET

cd $SRC

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh $XFCEDLD/$TARGETBALL

cd $TARGETDIR

echo \ \ Configuring...
./configure --prefix=/usr \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
paco -p $TARGET 'make install' \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

echo -n \ \ Pacoing:\   && paco $TARGET || echo none 

echo \ \ Removing directory...
cd .. && rm -fr $TARGETDIR

