#!/bin/sh

. ./_blfsset.sh

APPNAME=subversion
VER=1.8.10
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.bz2
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	apr-util sqlite 
. $WRK/_checkOptions.sh  \
	openssl serf httpd cyrus-sasl dbus kdelibs \
	python-2 ruby swig openjdk dante jikes junit
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

if [ ${OPTION_httpd} -eq "1" ]; then
  export WITHHTTPD="--with-apr=/usr --with-apr-util=/usr --with-apr-memcache=/usr --with-apache-libexecdir "
else
  export WITHHTTPD=""
  . $WRK/_checkRequired.sh apr apr-util || exit 1
fi

unset MAKEFLAGS

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

#sed -i 's/version" !=/version" </' \
#    build/ac-macros/berkeley-db.m4 &&
#autoconf

#echo \ \ Unofficial patch...
#patch -Np1 -i $WRK/patch/subversion-$VER.patch \
#	1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1

#echo \ \ Patching...
#patch -Np1 -i $DLD/subversion-$VER-build_fixes-1.patch \
#	1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1

Configuring
./configure --prefix=/usr --disable-static \
	$WITHHTTPD \
$([ ${OPTION_openjdk} -eq 1 ] && echo --enable-javahl) \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

if [ ${OPTION_openjdk} -eq 1 ]; then
echo Making javahl...
make javahl \
        1>> $LOG/$TARGET.2_make.log 2>&1 || exit 1
fi

if [ ${OPTION_swig} -eq "1" ]; then
echo Making swig-pl...
make swig-pl \
        1>> $LOG/$TARGET.2_make.log 2>&1 || exit 1
echo Making swig-py...
make swig-py \
     swig_pydir=/usr/lib/python2.7/site-packages/libsvn \
     swig_pydir_extra=/usr/lib/python2.7/site-packages/svn \
        1>> $LOG/$TARGET.2_make.log 2>&1 || exit 1
fi

Installing
porg -lp $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1
install -m755 -d /usr/share/doc/subversion-$VER
porg -lp+ $TARGET "\
cp      -v -R       doc/* \
                    /usr/share/doc/subversion-$VER" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

if [ ${OPTION_openjdk} -eq 1 ]; then
echo Installing javahl...
porg -lp+ $TARGET "\
make install-javahl" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1
fi

if [ ${OPTION_swig} -eq "1" ]; then
echo Installing swig-pl...
porg -lp+ $TARGET 'make install-swig-pl' \
        1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

echo Installing swig-py...
porg -lp+ $TARGET "\
make install-swig-py \
      swig_pydir=/usr/lib/python2.7/site-packages/libsvn \
      swig_pydir_extra=/usr/lib/python2.7/site-packages/svn" \
        1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1
fi

TimeEnd

cd ..
RemoveSrcDir
PorgingDone

