#!/bin/sh

. ./_blfsset.sh

APPNAME=openldap
VER=2.4.40
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tgz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	db
. $WRK/_checkOptions.sh  \
	openslp tcp_wrappers cyrus-sasl icu \
	unixODBC
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

mkdir -p /var/lib/openldap

groupadd -g 83 ldap
useradd -c "OpenLDAP Daemon Owner" -d /var/lib/openldap -u 83 \
        -g ldap -s /bin/false ldap

cd $TARGETDIR

Patching
patch -Np1 -i $DLD/openldap-$VER-blfs_paths-1.patch \
	1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1
patch -Np1 -i $DLD/openldap-$VER-symbol_versions-1.patch \
	1>> $LOG/$TARGET.0_patch.log 2>&1 || exit 1
autoconf \
	1>> $LOG/$TARGET.0_patch.log 2>&1 || exit 1

sed -i '/6.0.20/ a\\t__db_version_compat' configure

Configuring
./configure --prefix=/usr         \
            --sysconfdir=/etc     \
            --localstatedir=/var  \
            --libexecdir=/usr/lib \
            --disable-static      \
            --enable-dynamic      \
            --disable-debug       \
            --enable-crypt        \
$([ ${OPTION_cyrussasl} -eq 1 ] && echo --enable-spasswd) \
            --enable-modules      \
            --enable-rlookups     \
            --enable-backends=mod \
            --enable-overlays=mod \
            --disable-ndb         \
            --disable-sql         \
$([ ${OPTION_openslp} -eq 1 ] && echo --enable-slpd) \
$([ ${OPTION_tcp_wrappers} -eq 1 ] && echo --enable-wrappers) \
$([ ${OPTION_cyrussasl} -ne 1 ] && echo --without-cyrus-sasl) \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

echo Making depend...
make depend \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Making
make \
	1>> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
porg -lp  $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

chmod 700 /var/lib/openldap
chown -R ldap:ldap /var/lib/openldap
chmod 640 /etc/openldap/{slapd.{conf,ldif},DB_CONFIG.example}
chown root:ldap /etc/openldap/{slapd.{conf,ldif},DB_CONFIG.example}
porg -lp+ $TARGET "\
install -v -dm700 -o ldap -g ldap /etc/openldap/slapd.d" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

install -dm 755 /usr/share/doc/openldap-$VER

porg -lp+ $TARGET "\
cp -vfr doc/drafts /usr/share/doc/openldap-$VER" \
	1>> $LOG/$TARGET.4_install.log 2>&1

porg -lp+ $TARGET "\ 
cp -vfr doc/rfc    /usr/share/doc/openldap-$VER" \
	1>> $LOG/$TARGET.4_install.log 2>&1

porg -lp+ $TARGET "\
cp -vfr doc/guide  /usr/share/doc/openldap-$VER" \
	1>> $LOG/$TARGET.4_install.log 2>&1

TimeEnd

cd ..
RemoveSrcDir
PorgingDone

