#!/bin/sh

. ./_blfsset.sh

APPNAME=openjade
VER=1.3.2
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.gz
TARGETDIR=$TARGET

echo Check Required...
./_checkRequired.sh OpenSP || exit 1

if test "$1" == "check"; then
  exit 0
fi

cd $SRC

echo $TARGET

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

START=`date +'%Y/%m/%d %H:%M:%S.%N'`

cd $TARGETDIR

echo \ \ Patching...
patch -Np1 -i $DLD/openjade-$VER-gcc_4.6-1.patch \
	1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1

sed -i -e '/getopts/{N;s#&G#g#;s#do .getopts.pl.;##;}' \
       -e '/use POSIX/ause Getopt::Std;' msggen.pl

echo \ \ Configuring...
./configure --prefix=/usr                                \
            --enable-http                                \
            --disable-static                             \
            --enable-default-catalog=/etc/sgml/catalog   \
            --enable-default-search-path=/usr/share/sgml \
            --datadir=/usr/share/sgml/openjade-1.3.2     \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
paco -p  $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "make install-man" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
ln -v -sf openjade /usr/bin/jade"
paco -p+ $TARGET "\
ln -v -sf libogrove.so /usr/lib/libgrove.so"
paco -p+ $TARGET "\
ln -v -sf libospgrove.so /usr/lib/libspgrove.so"
paco -p+ $TARGET "\
ln -v -sf libostyle.so /usr/lib/libstyle.so"
paco -p+ $TARGET "\
install -v -m644 dsssl/catalog /usr/share/sgml/openjade-$VER/"
paco -p+ $TARGET "\
install -v -m644 dsssl/*.{dtd,dsl,sgm} \
    /usr/share/sgml/openjade-$VER"
paco -p+ $TARGET "\
install-catalog --add /etc/sgml/openjade-$VER.cat \
    /usr/share/sgml/openjade-$VER/catalog"
paco -p+ $TARGET "\
install-catalog --add /etc/sgml/sgml-docbook.cat \
    /etc/sgml/openjade-$VER.cat"

END=`date +'%Y/%m/%d %H:%M:%S.%N'`

echo `cat /etc/lfs-release`,$TARGET,$START,$END \
        >> $TME/$APPNAME.txt

echo -n \ \ Pacoing:\   && paco $TARGET || echo none

echo \ \ Removing directory...
cd .. && rm -fr $TARGETDIR

