#!/bin/sh

. ./_blfsset.sh

APPNAME=net-tools
VER=20101030
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$APPNAME-CVS_$VER.tar.gz
TARGETDIR=$APPNAME-CVS_$VER

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Patching
patch -Np1 -i $DLD/net-tools-CVS_20101030-remove_dups-1.patch \
	1>$LOG/$TARGET.0_patch.log 2>&1 || exit 1

Configuring
yes "" | make config \
	1>$LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
porg -lp $TARGET "make update" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PorgingDone

