#!/bin/sh

. ./_blfsset.sh

APPNAME=libvpx
VER=1.3.0
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/libvpx-v$VER.tar.xz
TARGETDIR=libvpx-v$VER

echo $TARGET

. $WRK/_checkRequired.sh \
	yasm which
. $WRK/_checkOptions.sh  \
	doxygen php
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

sed -i 's/cp -p/cp/' build/make/Makefile
chmod 644 vpx/*.h

mkdir ../libvpx-build
cd ../libvpx-build

Configuring
../libvpx-v$VER/configure --prefix=/usr \
                           --enable-shared \
                           --disable-static \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
rm -fr libvpx-build
PacoingDone

