#!/bin/sh

cat > /etc/rc.d/init.d/slim << "EOF"
#!/bin/bash

. /lib/lsb/init-functions

# Read in the command arguments
case "$1" in
    start)
        log_info_msg "Starting SLiM Display Manager..."
        /usr/bin/slim -d
        evaluate_retval
        ;;
    stop)
        log_info_msg "Stopping SLiM Display Manager..."
        if [ -r /var/run/slim.lock ]; then
          PID=$(cat /var/run/slim.lock)
          kill $PID
        fi
        evaluate_retval
        ;;
    restart)
        $0 stop
        sleep 2
        $0 start
        ;;
    status)
        statusproc /usr/bin/slim
        ;;
    *)
        echo "Usage: $0 {start|stop|restart|status}"
        exit 1
esac

exit 0

# End $rc_base/init.d/slim
EOF

chmod 754 /etc/rc.d/init.d/slim

