#!/bin/sh

VER=20110511
TARGET=mobile-broadband-provider-info-$VER
TARGETBALL=$TARGET.tar.bz2
TARGETDIR=$TARGET

. ../_blfsset.sh
. ../Xorg/_xorgset.sh
. ./_gnomeset.sh

echo Check Required...
../_checkRequired.sh || exit 1

#echo Check Options...
#. ../_checkOptions.sh 

if test "$1" == "check"; then
  exit 0
fi

cd $SRC

echo $TARGET

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

cd $TARGETDIR

echo \ \ Configuring...
./configure --prefix=$GNOME_PREFIX \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
paco -p  $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

echo -n \ \ Pacoing:\   && paco $TARGET || echo none

echo \ \ Removing directory...
cd .. && rm -fr $TARGETDIR

