#!/bin/sh

. ../_blfsset.sh
. ./_gnomeset.sh

APPNAME=gvfs
VER=1.18.3
TARGET=$APPNAME-$VER
TARGETBALL=$GNOMEDLD/$TARGET.tar.xz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	dbus glib-2 intltool
. $WRK/_checkOptions.sh  \
	gtk+-3 libsecret libsoup udisks-2 \
	avahi bluez dbus-glib fuse libarchive \
	libbluray libcdio libgphoto2 libimobiledevice \
	openssh samba
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

unset MAKEFLAGS

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Configuring
./configure --prefix=/usr \
            --sysconfdir=/etc \
            --libexecdir=/usr/lib/gvfs \
$([ ${OPTION_libgphoto2} -ne 1 ] && echo --disable-gphoto2) \
	    --disable-man \
	    --disable-documentation \
	    --disable-gtk-doc \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p  $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

