#!/bin/sh

. ./_blfsset.sh

APPNAME=docbook-dsssl
VER=1.79
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.bz2
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	sgml-common
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

echo Extracting doc...
tar xf $DLD/docbook-dsssl-doc-$VER.tar.bz2 

install -v -m755 bin/collateindex.pl /usr/bin 

paco -p $TARGET "\
install -v -m644 bin/collateindex.pl.1 /usr/share/man/man1" \
	1> $LOG/$TARGET.1_conf.log 2>&1

install -v -d -m755 /usr/share/sgml/docbook/dsssl-stylesheets-$VER

paco -p+ $TARGET "\
cp -v -R * /usr/share/sgml/docbook/dsssl-stylesheets-$VER" \
	1>> $LOG/$TARGET.1_conf.log 2>&1

paco -p+ $TARGET "\
install-catalog --add /etc/sgml/dsssl-docbook-stylesheets.cat \
    /usr/share/sgml/docbook/dsssl-stylesheets-$VER/catalog" \
	1>> $LOG/$TARGET.1_conf.log 2>&1

paco -p+ $TARGET "\
install-catalog --add /etc/sgml/dsssl-docbook-stylesheets.cat \
    /usr/share/sgml/docbook/dsssl-stylesheets-$VER/common/catalog" \
	1>> $LOG/$TARGET.1_conf.log 2>&1
 
paco -p+ $TARGET "\
install-catalog --add /etc/sgml/sgml-docbook.cat \
    /etc/sgml/dsssl-docbook-stylesheets.cat" \
	1>> $LOG/$TARGET.1_conf.log 2>&1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

