#!/bin/sh

. ./_blfsset.sh

APPNAME=cmake
VER=3.0.2
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	curl libarchive expat
. $WRK/_checkOptions.sh  \
	subversion qt-4
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

#Patching
#patch -Np1 -i $DLD/cmake-$VER-freetype-1.patch \
#	1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1

echo Bootstrapping...
./bootstrap --prefix=/usr \
            --system-libs \
            --mandir=/share/man \
            --docdir=/share/doc/cmake-$VER \
            $([ ${OPTION_qt4} -eq 1 ] && echo --qt-gui) \
	1> $LOG/$TARGET.1_boot.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
porg -lp  $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PorgingDone

