#!/bin/sh

. ./_blfsset.sh

APPNAME=boost
VER=1.55.0
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/${APPNAME}_1_55_0.tar.bz2
TARGETDIR=${APPNAME}_1_55_0

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  \
	icu python-2
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

unset MAKEFLAGS

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

#Patching
#patch -Np1 -i $DLD/boost-$VER-glibc-1.patch \
#	1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1

echo Bootstrapping
./bootstrap.sh --prefix=/usr \
	1> $LOG/$TARGET.1_boot.log 2>&1 || exit 1

Making
paco -p $TARGET "\
./b2 stage threading=multi link=shared " \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET "\
./b2 install threading=multi link=shared" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

