#!/bin/sh

. ../_blfsset.sh

VER=1.10.2
TARGET=webkitgtk-$VER
TARGETBALL=$TARGET.tar.xz
TARGETDIR=$TARGET

echo Check Required...
../_checkRequired.sh gperf icu libxslt gtk+-2 \
	libsoup geoclue which sqlite \
	gst-plugins-base || exit 1
if test "$1" == "check"; then
  exit 0
fi

cd $SRC

echo $TARGET

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh $XORGDLD/$TARGETBALL

cd $TARGETDIR

sed -i '/generate-gtkdoc --rebase/s:^:# :' GNUmakefile.in

echo \ \ Configuring...
./configure --prefix=/usr \
	--enable-introspection \
	--with-gtk=2.0 \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
paco -p $TARGET 'make install' \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

echo -n \ \ Pacoing:\   && paco $TARGET || echo none

echo \ \ Removing directory...
cd .. && rm -fr $TARGETDIR


