#!/bin/sh

. ../_blfsset.sh
. ./_xorgset.sh

section=proto
version=$XORGVERSION

TARGET=${section}-${version}
TARGETDIR=${section}

mkdir -pv $XORGDLD/$TARGETDIR
mkdir -pv $XORGSRC/$TARGETDIR

. $WRK/_checkRequired.sh Xorg-init util-macros
. $WRK/_checkOptions.sh  ""
. $WRK/_checkExit.sh "$1" || exit $?

cd $XORGDLD/$TARGETDIR

echo Wgetting... 
grep -v '^#' $XORGWRK/${section}-${version}.md5 | awk '{print $2}'| wget -N -i- -c \
	-B http://xorg.freedesktop.org/releases/individual/proto/ \
	1>$LOG/Xorg-proto.log 2>&1

echo Md5summing..
md5sum -c $XORGWRK/${section}-${version}.md5 \
	1>>$LOG/Xorg-${section}.log 2>&1 || exit 1

cd $XORGSRC/$TARGETDIR

# build packages
for package in $(grep -v '^#' $XORGWRK/${section}-${version}.md5 | awk '{print $2}')
do
  packagedir=$(echo $package | sed 's/.tar.bz2//')
echo $packagedir
echo \ \ Removing old directory...
  rm -fr $packagedir
echo \ \ Extracting...
  tar -xf $XORGDLD/$TARGETDIR/$package
  cd $packagedir
START=`date +'%Y/%m/%d %H:%M:%S.%N'`
echo \ \ Configuring...
  ./configure $XORG_CONFIG \
	1> $LOG/Xorg-${section}-$packagedir.1_conf.log 2>&1 || exit 1
echo \ \ Making...
  make \
	1> $LOG/Xorg-${section}-$packagedir.2_make.log 2>&1 || exit 1
echo \ \ Installing...
  porg -lp Xorg-${section}-${packagedir} 'make install' \
	1> $LOG/Xorg-${section}-$packagedir.3_install.log 2>&1 || exit 1
END=`date +'%Y/%m/%d %H:%M:%S.%N'`
echo `cat /etc/lfs-release`,$TARGET,$START,$END \
        >> $TME/Xorg-${section}-${packagedir}.txt
echo -n \ \ Porging:\   && porg Xorg-proto-$packagedir || echo none
  cd ..
echo \ \ Removing directory...
  rm -fr $packagedir
done

