#!/bin/sh

. ../_blfsset.sh
. ./_xorgset.sh

section=lib
version=$XORGVERSION

TARGET=${section}-${version}
TARGETDIR=${section}

mkdir -pv $XORGDLD/$TARGETDIR
mkdir -pv $XORGSRC/$TARGETDIR

cd $XORGDLD/$TARGETDIR

echo Wgetting...
grep -v '^#' $XORGWRK/${section}-${version}.md5 | awk '{print $2}' | wget -N -i- -c \
    -B http://xorg.freedesktop.org/releases/individual/${section}/ \
        1> $LOG/Xorg-$section.log 2>&1
md5sum -c $XORGWRK/${section}-${version}.md5 \
        1>> $LOG/Xorg-$section.log 2>&1

unset MAKEFLAGS

cd $XORGSRC/$TARGETDIR

# build packages
for package in $(grep -v '^#' $XORGWRK/${section}-${version}.md5 | awk '{print $2}')
do
  packagedir=$(echo $package | sed 's/.tar.bz2//')
echo $packagedir
echo \ \ Removing old directory...
  rm -fr $packagedir
echo \ \ Extracting...
  tar -xf $XORGDLD/$TARGETDIR/$package || (echo Tarball not found && exit 1)
  cd $packagedir

case $packagedir in
xtrans-[0-9]* )
#echo \ \ Patching...
#  patch -Np1 -i $DLD/xtrans-1.2.5.patch \
#	1> $LOG/Xorg-${section}-$packagedir.1_patch.log 2>&1 || exit 1
#  ;;
esac
echo \ \ Configuring...

case $packagedir in
  libXfont-[0-9]* )
      ./configure $XORG_CONFIG --disable-devel-docs \
        1> $LOG/Xorg-$section-$packagedir.1_conf.log 2>&1 || exit 1
      ;;
  libXt-[0-9]* )
      ./configure $XORG_CONFIG \
        --with-appdefaultdir=/etc/X11/app-defaults \
        1> $LOG/Xorg-$section-$packagedir.1_conf.log 2>&1 || exit 1
      ;;
  * )
      ./configure $XORG_CONFIG \
        1> $LOG/Xorg-$section-$packagedir.1_conf.log 2>&1 || exit 1
      ;;
esac 

echo \ \ Making...
  make \
	1> $LOG/Xorg-$section-$packagedir.2_make.log 2>&1 || exit 1
echo \ \ Installing...
  porg -lp Xorg-${section}-${packagedir} "make install" \
	1> $LOG/Xorg-$section-$packagedir.3_install.log 2>&1 || exit 1
  ldconfig
echo -n \ \ Porging:\   && porg Xorg-${section}-${packagedir} || echo none
  cd ..
echo \ \ Removing directory...
  rm -fr $packagedir
done

#ln -sv $XORG_PREFIX/lib/X11 /usr/lib/X11
#ln -sv $XORG_PREFIX/include/X11 /usr/include/X11

