#!/bin/sh

. ../_blfsset.sh
. ./_xorgset.sh

unset MAKEFLAGS

section=app
version=$XORGVERSION

TARGET=${section}-${version}
TARGETDIR=${section}

mkdir -pv $XORGDLD/$TARGETDIR
mkdir -pv $XORGSRC/$TARGETDIR

cd $XORGDLD/$TARGETDIR

grep -v '^#' $XORGWRK/${section}-${version}.md5 | awk '{print $2}' | wget -N -i- -c \
    -B http://xorg.freedesktop.org/releases/individual/${section}/ \
	1> $LOG/Xorg-$section.log 2>&1
md5sum -c $XORGWRK/${section}-${version}.md5 \
	1>> $LOG/Xorg-$section.log 2>&1

cd $XORGSRC/$TARGETDIR

# build packages
for package in $(grep -v '^#' $XORGWRK/${section}-${version}.md5 | awk '{print $2}')
do
  packagedir=$(echo $package | sed 's/.tar.bz2//')
echo $packagedir
echo \ \ Removing old directory...
  rm -fr $packagedir
echo \ \ Extracting...
  tar -xf $XORGDLD/$TARGETDIR/$package || (echo Tarball not found && exit 1)
  cd $packagedir
echo \ \ Patching...
case $packagedir in
  luit-[0-9]* )
   line1="#ifdef _XOPEN_SOURCE"
   line2="#  undef _XOPEN_SOURCE"
   line3="#  define _XOPEN_SOURCE 600"
   line4="#endif"

   sed -i -e "s@#ifdef HAVE_CONFIG_H@$line1\n$line2\n$line3\n$line4\n\n&@" sys.c
   unset line1 line2 line3 line4
   ;;
esac
echo \ \ Configuring...
case $packagedir in
           * )
               ./configure $XORG_CONFIG \
		1> $LOG/$packagedir.1_conf.log 2>&1 || exit 1
               ;;
esac

echo \ \ Making...
  make \
	1> $LOG/$packagedir.2_make.log 2>&1 || exit 1

echo \ \ Installing...
  paco -p Xorg-${section}-${packagedir} 'make install' \
	1> $LOG/$packagedir.3_install.log 2>&1 || exit 1
  cd ..

echo -n \ \ Pacoing:\   && paco Xorg-${section}-${packagedir} || echo none

echo \ \ Removing directory...
  rm -fr $packagedir
done

