#/bin/sh

THISFILE=`basename $0`
CHAP=`echo $THISFILE | sed s/\.sh//`

. ./_lfsset.sh

VER=$LINUX_VER
TARGET=linux-$VER
TARGETBALL=$TARGET.tar.xz
TARGETDIR=$TARGET

cd $SRC

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

cd $TARGETDIR

START=`date +'%Y/%m/%d %H:%M:%S.%N'`

echo \ \ Making mrproper...
make mrproper \
	1> $LOG/$CHAP.$TARGET.1_mrproper.log 2>&1

make LANG=C LC_ALL= menuconfig 

make \
	1> $LOG/$CHAP.$TARGET.3_make.log 2>&1 || exit 1

paco -p $TARGET "make modules_install" \
	1> $LOG/$CHAP.$TARGET.4_make.log 2>&1 || exit 1

paco -p+ $TARGET "\
cp -v arch/x86/boot/bzImage /boot/vmlinuz-$VER-lfs-SYSTEMD-$SVNVER"

paco -p+ $TARGET "\
cp -v System.map /boot/System.map-$VER"

paco -p+ $TARGET "\
cp -v .config /boot/config-$VER"

install -d /usr/share/doc/linux-$VER

paco -p+ $TARGET "\
cp -r Documentation/* /usr/share/doc/linux-$VER"

cat > /etc/modprobe.conf << "EOF"
# Begin /etc/modprobe.conf

install ohci_hcd /sbin/modprobe ehci_hcd ; /sbin/modprobe -i ohci_hcd ; true
install uhci_hcd /sbin/modprobe ehci_hcd ; /sbin/modprobe -i uhci_hcd ; true

# End /etc/modprobe.conf
EOF
paco -p+ $TARGET "touch /etc/modprobe.conf"

END=`date +'%Y/%m/%d %H:%M:%S.%N'`

echo $CHAP, $TARGET, $START, $END \
	>> $TME/lfstime.txt

echo -n \ \ Pacoing:\   && paco $TARGET || echo none

echo \ \ Removing directory...
cd .. && rm -fr $TARGETDIR


echo \ \ Done.

