#/bin/sh

CHAP=7all

. ./_lfsset.sh

VER=${BOOTSCRIPTVER}
TARGET=lfs-bootscripts-$VER
TARGETBALL=$TARGET.tar.bz2
TARGETDIR=$TARGET

START=`date +'%Y/%m/%d %H:%M:%S.%N'`

echo new 7.2
cd /etc/sysconfig/
cat > ifconfig.enp2s1 << "EOF"
ONBOOT=yes
IFACE=enp2s1
SERVICE=ipv4-static
IP=192.168.11.95
GATEWAY=192.168.11.1
PREFIX=24
BROADCAST=192.168.11.255
EOF

echo new 7.2.3
cat > /etc/resolv.conf << "EOF"
# Begin /etc/resolv.conf

domain localdomain
nameserver 192.168.11.1

# End /etc/resolv.conf
EOF

echo new 7.3
cat > /etc/hosts << "EOF"
# Begin /etc/hosts (network card version)

127.0.0.1 localhost
192.168.11.95 LFS64systemd.localdomain LFS64systemd

# End /etc/hosts (network card version)
EOF

echo "LFS32systemd" > /etc/hostname

cat > /etc/sysconfig/clock << "EOF"
# Begin /etc/sysconfig/clock

UTC=0

# Set this to any options you might need to give to hwclock, 
# such as machine hardware clock type for Alphas.
CLOCKPARAMS=

# End /etc/sysconfig/clock
EOF

echo new 7.10

cat > /etc/sysconfig/console << "EOF"
# Begin /etc/sysconfig/console

UNICODE="1"
KEYMAP="jp106"
FONT=""

# End /etc/sysconfig/console
EOF

echo new 7.13

cat > /etc/locale.conf << "EOF"
export LANG=ja_JP.UTF-8
EOF

echo new 7.14

cat > /etc/inputrc << "EOF"
# Begin /etc/inputrc
# Modified by Chris Lynn <roryo@roryo.dynup.net>

# Allow the command prompt to wrap to the next line
set horizontal-scroll-mode Off

# Enable 8bit input
set meta-flag On
set input-meta On

# Turns off 8th bit stripping
set convert-meta Off

# Keep the 8th bit for display
set output-meta On

# none, visible or audible
set bell-style none

# All of the following map the escape sequence of the value
# contained in the 1st argument to the readline specific functions
"\eOd": backward-word
"\eOc": forward-word

# for linux console
"\e[1~": beginning-of-line
"\e[4~": end-of-line
"\e[5~": beginning-of-history
"\e[6~": end-of-history
"\e[3~": delete-char
"\e[2~": quoted-insert

# for xterm
"\eOH": beginning-of-line
"\eOF": end-of-line

# for Konsole
"\e[H": beginning-of-line
"\e[F": end-of-line

# End /etc/inputrc
EOF

