#/bin/sh

THISFILE=`basename $0`
CHAP=`echo $THISFILE | sed s/\.sh//`

VER=2.0.9
TARGET=paco-$VER
TARGETBALL=$TARGET.tar.bz2
TARGETDIR=$TARGET

. ./_lfsset.sh

echo $CHAP: $TARGET

cd $SRC

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

cd $TARGETDIR

echo \ \ Configuring...
./configure --prefix=/usr --sysconfdir=/etc \
	--enable-scripts --disable-gpaco \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
make install \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

make logme

echo \ \ Removing directory...
cd .. && rm -fr $TARGETDIR

echo \ \ Done.

