#/bin/sh

THISFILE=`basename $0`
CHAP=`echo $THISFILE | sed s/\.sh//`

VER=1.26
TARGET=tar-$VER
TARGETBALL=$TARGET.tar.bz2
TARGETDIR=$TARGET

echo $CHAP: $TARGET

. ./_lfsset.sh

cd $SRC

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

START=`date +'%Y/%m/%d %H:%M:%S.%N'`

cd $TARGETDIR

sed -i -e '/gets is a/d' gnu/stdio.in.h

echo \ \ Configuring...
FORCE_UNSAFE_CONFIGURE=1 ./configure --prefix=/usr \
   --bindir=/bin --libexecdir=/usr/sbin \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1

echo \ \ Making...
make \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1

echo \ \ Installing...
paco -p $TARGET "make install" \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1

echo \ \ Installing doc...
paco -p $TARGET "make -C doc install-html docdir=/usr/share/doc/tar-$VER" \
	1> $LOG/$CHAP.$TARGET.4_install.log 2>&1

END=`date +'%Y/%m/%d %H:%M:%S.%N'`

echo $CHAP, $TARGET, $START, $END \
	>> $TME/lfstime.txt

echo -n \ \ Pacoing:\   && paco $TARGET || echo none

echo \ \ Removing directory...
cd .. && rm -fr $TARGETDIR

echo \ \ Done.

