#/bin/sh

THISFILE=`basename $0`
CHAP=`echo $THISFILE | sed s/\.sh//`

. ./_clfsset.sh

VER=1.15.3
TARGET=kbd-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $CHAP: $TARGET

cd $SRC

RemoveSrcDir
Extract
TimeStart

cd $TARGETDIR

echo Patching...
patch -Np1 -i $DLD/kbd-$VER-es.po_fix-1.patch \
	1> $LOG/$CHAP.$TARGET.0_patch.log 2>&1 || exit 1

echo Configuring...
CC="gcc ${BUILD64}" ./configure --prefix=/usr \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1 || exit 1

echo Making...
make CC="gcc ${BUILD64}" \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo Installing...
paco -p $TARGET "\
make install" \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
mv -v /usr/bin/{kbd_mode,dumpkeys,loadkeys,openvt,setfont,setvtrgb} /bin" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

