#/bin/sh

THISFILE=`basename $0`
CHAP=`echo $THISFILE | sed s/\.sh//`

. ./_clfsset.sh

VER=1.0.6
TARGET=bzip2-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $CHAP: $TARGET

cd $SRC

RemoveSrcDir
Extract
TimeStart

cd $TARGETDIR

sed -i -e 's:ln -s -f $(PREFIX)/bin/:ln -s :' Makefile
sed -i 's@/lib\(/\| \|$\)@/lib64\1@g' Makefile

echo Making...
make -f Makefile-libbz2_so CC="gcc ${BUILD64}" CXX="g++ ${BUILD64}" \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1
make clean \
	1>> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1
make CC="gcc ${BUILD64}" CXX="g++ ${BUILD64}" \
	1>> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo Installing...
paco -p+ $TARGET "\
make CC=\"gcc ${BUILD64}\" CXX=\"g++ ${BUILD64}\" PREFIX=/usr install" \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
cp -v bzip2-shared /bin/bzip2" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
cp -av libbz2.so* /lib64" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
ln -sv ../../lib64/libbz2.so.1.0 /usr/lib64/libbz2.so" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
rm -v /usr/bin/{bunzip2,bzcat,bzip2}" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
ln -sv bzip2 /bin/bunzip2" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
ln -sv bzip2 /bin/bzcat" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

