#/bin/sh

THISFILE=`basename $0`
CHAP=`echo $THISFILE | sed s/\.sh//`

. ./_clfsset.sh

VER=4.2
TARGET=bash-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $CHAP: $TARGET

cd $SRC

RemoveSrcDir
Extract
TimeStart

cd $TARGETDIR

echo Patching...
patch -Np1 -i $DLD/bash-$VER-branch_update-6.patch \
	1> $LOG/$CHAP.$TARGET.0_patch.log 2>&1 || exit 1

sed -i "/ac_cv_rl_libdir/s@/lib@&64@" configure

echo Configuring...
CC="gcc ${BUILD64}" CXX="g++ ${BUILD64}" \
    ./configure --prefix=/usr --bindir=/bin \
    --without-bash-malloc --with-installed-readline \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1 || exit 1

echo Making...
make \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo Installing...
paco -p+ $TARGET "\
make htmldir=/usr/share/doc/bash-4.2 install" \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

exec /bin/bash --login +h

