#/bin/sh

THISFILE=`basename $0`
CHAP=`echo $THISFILE | sed s/\.sh//`

. ./_clfsset.sh

VER=4.1.5.1
TARGET=shadow-$VER
TARGETBALL=$DLD/$TARGET.tar.bz2
TARGETDIR=$TARGET

echo $CHAP: $TARGET

cd $SRC

RemoveSrcDir
Extract
TimeStart

cd $TARGETDIR

sed -i 's/groups$(EXEEXT) //' src/Makefile.in
find man -name Makefile.in -exec sed -i '/groups\.1\.xml/d' '{}' \;
find man -name Makefile.in -exec sed -i 's/groups\.1 / /' {} \;

echo Configuring...
CC="gcc ${BUILD64}" ./configure --sysconfdir=/etc \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1 || exit 1

echo Making...
make \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo Installing...
paco -p $TARGET "\
make install " \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

sed -i /etc/login.defs \
    -e 's@#\(ENCRYPT_METHOD \).*@\1SHA512@' \
    -e 's@/var/spool/mail@/var/mail@'

paco -p+ $TARGET "\
mv -v /usr/bin/passwd /bin" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

pwconv
grpconv

TimeEnd

passwd root

cd ../..
RemoveSrcDir
PacoingDone
