#/bin/sh

THISFILE=`basename $0`
CHAP=`echo $THISFILE | sed s/\.sh//`

. ./_clfsset.sh

VER=2.23
TARGET=binutils-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $CHAP: $TARGET

cd $SRC

RemoveSrcDir
Extract
TimeStart

cd $TARGETDIR

mkdir -v ../binutils-build
cd ../binutils-build

echo Configuring...
CC="gcc -isystem /usr/include ${BUILD64}" \
LDFLAGS="-Wl,-rpath-link,/usr/lib64:/lib64:/usr/lib:/lib ${BUILD64}" \
  ../binutils-$VER/configure --prefix=/usr \
    --enable-shared --enable-64-bit-bfd --libdir=/usr/lib64 \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1 || exit 1

echo Making...
make configure-host \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1
make tooldir=/usr \
	1>> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo Installing...
paco -p $TARGET "\
make tooldir=/usr install" \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
cp -v ../binutils-$VER/include/libiberty.h /usr/include" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone
