#/bin/sh

. ./_cblfsset.sh

APPNAME=screen
VER=4.0.3
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

checkRequired ""
checkOptions  ""
checkTarball
checkExit "$1" || exit $?

cd $SRC

BIT64
RemoveSrcDir
Extract
TimeStart

cd $TARGETDIR

echo Configuring...
CC="gcc ${BUILD64}" ./configure --prefix=/usr \
    --with-socket-dir=/var/run/screen \
    --with-sys-screenrc=/etc/screenrc \
        1> $LOG/$TARGET.$BIT.1_conf.log 2>&1 || exit 1

sed -i "s%/usr/local/etc/screenrc%/etc/screenrc%" {etc,doc}/*

echo Making...
make \
        1> $LOG/$TARGET.$BIT.2_make.log 2>&1 || exit 1

echo Installing...
paco -p $TARGET "\
make install" \
        1> $LOG/$TARGET.$BIT.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
install -m 644 etc/etcscreenrc /etc/screenrc" \
        1> $LOG/$TARGET.$BIT.3_install.log 2>&1 || exit 1

TimeEnd
cd ..
RemoveSrcDir
PacoingDone

