BOOTSCRIPTVER=20130216
SVNVER=1.2.0
LINUX_VER=3.4.17

CLFS=/mnt/clfs
SRC=$CLFS/sources/CLFS
DLD=$CLFS/download/BLFS
WRK=$CLFS/work/LFScripts/CBLFS
WRKBLFS=$CLFS/work/LFScripts/BLFS
LOG=$WRK/log
TME=$WRK/time

mkdir -pv $LOG $TME

function checkRequired() {
  echo --------------------
  echo Check Required...
  
  ERROR=0
  
  while [ "$1" != "" ]
  do
    echo -n \ \ $1... 
    paco -i $1 > /dev/null 2>&1
    retvalue=$?
  
    if [ $retvalue -eq 0 ]; then
      echo Ok
    else
      echo -e "\e[31;1mno\e[m"
      ERROR=1
    fi
  
    shift
  done
  
  echo --------------------
  return $ERROR
}

function checkOptions() {
echo Check Options...

while [ "$1" != "" ]
do
  echo -n \ \ $1... 
  paco -i $1 > /dev/null 2>&1
  retvalue=$?

  NAME=`echo $1 | sed -e 's/-//g'i -e 's/\+//g'`
  if [ $retvalue -eq 0 ]; then
    echo Ok
    export OPTION_$NAME=1
    export OPT_$NAME=1
  else
    echo -e "\e[31;1mno\e[m"
    export OPTION_$NAME=0
    export OPT_$NAME=0
  fi

  shift
done

echo --------------------
}

function checkTarball() {
  echo Check Tarball...

  echo -n \ \ Tarball $TARGETBALL" "
  if [ -e $TARGETBALL ]; then
    echo  found
  else
    echo -e "\e[31;1mnot found\e[m" && ERROR=1
  fi
  echo --------------------
}

function checkExit() {

  if [ "$1" == "check" -o ${ERROR} == 1 ]; then
    return 1
  fi

  return 0
}

function BIT32() {
  BIT=32
  echo $BIT bit...
}

function BIT64() {
  BIT=64
  echo $BIT bit...
}

function TimeStart() {
  START=`date +'%Y/%m/%d %H:%M:%S.%N'`
  return 0
}

function TimeEnd() {
  END=`date +'%Y/%m/%d %H:%M:%S.%N'`
  echo `cat /etc/clfs-release`,$TARGET,$START,$END \
        >> $TME/$APPNAME$APPVER.$BIT.txt
}

function RemoveSrcDir() {
  echo Removing source directory...
  rm -fr $TARGETDIR
}

function Extract() {
  local FILE=$TARGETBALL

  if test "$1" != ""; then
    FILE=$1
  fi

  echo Extracting sources...
  if test ! -f $FILE; then
    echo \ \ Tarball not found: $FILE && exit 1
  else
    tar xf $FILE
  fi
}

function PacoingDone() {
  local pkg=$TARGET
  if test "$1" != ""; then
    pkg=$1
  fi
  echo --------------------
  echo -n Pacoing:\   && paco $pkg || echo none
  echo Done.
}
