#!/bin/sh

. ./_blfsset.sh

APPNAME=unbound
VER=1.4.21
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	expat ldns openssl
. $WRK/_checkOptions.sh  \
	libevent python-2 swig doxygen
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

groupadd -g 88 unbound 
useradd -c "Unbound DNS resolver" -d /var/lib/unbound -u 88 \
        -g unbound -s /bin/false unbound

Configuring
./configure --prefix=/usr \
            --sysconfdir=/etc \
            --with-pidfile=/run/unbound.pid \
            --disable-static \
            $([ ${OPTION_libevent} -eq 1 ] && echo --with-libevent) \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
mv -v /usr/sbin/unbound-host /usr/bin" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

#paco -p+ $TARGET "\
#install -v -m 0755 -d /etc/unbound" \
#	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1
#unbound-anchor -a "/etc/unbound/root.key"
#paco -p+ $TARGET "touch /etc/unbound/root.key"

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

