#!/bin/sh

. ./_blfsset.sh

APPNAME=tcl
VER=8.6.1
VER2=8.6
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/${APPNAME}$VER-src.tar.gz
TARGETDIR=${APPNAME}$VER

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Configuring
cd unix &&
./configure --prefix=/usr \
            --enable-threads \
            --mandir=/usr/share/man \
	    $([ $(uname -m) = x86_64 ] && echo --enable-64bit) \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

sed -i \
    -e "s@^\(TCL_SRC_DIR='\).*@\1/usr/include'@" \
    -e "/TCL_B/s@='\(-L\)\?.*unix@='\1/usr/lib@" \
    tclConfig.sh

Installing
paco -p  $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "make install-private-headers" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "ln -v -sf tclsh${VER2} /usr/bin/tclsh" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

chmod -v 755 /usr/lib/libtcl${VER2}.so \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ../..
RemoveSrcDir
PacoingDone

