#!/bin/sh

. ./_blfsset.sh

APPNAME=shadow
VER=4.1.5.1
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/${APPNAME}_$VER.orig.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

sed -i 's/groups$(EXEEXT) //' src/Makefile.in 
find man -name Makefile.in -exec sed -i 's/groups\.1 / /' {} \;

sed -i -e 's@#ENCRYPT_METHOD DES@ENCRYPT_METHOD SHA512@' \
       -e 's@/var/spool/mail@/var/mail@' etc/login.defs 

Configuring
./configure --prefix=/usr --sysconfdir=/etc \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p  $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET 'mv -v /usr/bin/passwd /bin' \
	1>> $LOG/$TARGET.3_install.log 2>&1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

