#!/bin/sh

. ./_blfsset.sh

APPNAME=samba
VER=3.6.16
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	libtirpc
. $WRK/_checkOptions.sh  \
	popt Linux-PAM cups openldap gamin acl xfsprogs \
	python-2 libcap2 libunwind keyutils tdb avahi \
	openafs valgrind talloc
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

cd source3 

sed -i -e "s/python2.6 python2.5/python2.7 &/" \
       -e "s/python2.6-config python2.5-config/python2.7-config &/" \
          configure

Configuring
./configure \
    --prefix=/usr \
    --sysconfdir=/etc \
    --localstatedir=/var \
    --with-piddir=/run \
    --with-pammodulesdir=/lib/security \
    --with-fhs \
    --enable-nss-wrapper \
    --enable-socket-wrapper \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
sed -i "s/-ldl/& -ltirpc -lpthread/" Makefile
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET "\
make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
cp pkgconfig/wbclient.pc /usr/lib/pkgconfig" \ 
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
install -v -m755 ../nsswitch/libnss_win{s,bind}.so /lib" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
ln -v -sf libnss_winbind.so /lib/libnss_winbind.so.2" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
ln -v -sf libnss_wins.so    /lib/libnss_wins.so.2" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
install -v -m644 ../examples/smb.conf.default /etc/samba" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

if [ -d /etc/openldap/schema ]; then

paco -p+ $TARGET "\
install -v -m644    ../examples/LDAP/README              \
                        /etc/openldap/schema/README.LDAP" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
install -v -m644    ../examples/LDAP/samba*              \
                        /etc/openldap/schema" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
install -v -m755    ../examples/LDAP/{convert*,get*,ol*} \
                        /etc/openldap/schema" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

fi

paco -p+ $TARGET "\
install -v -m755 -d /usr/share/doc/samba-$VER" 

paco -p+ $TARGET "\
install -v -m644 ../docs/*.pdf /usr/share/doc/samba-$VER" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

#paco -p+ $TARGET "ln -v -s ../../samba/swat  /usr/share/doc/samba-$VER"

sed -e "s/MYGROUP/WORKGROUP/" \
    -e "s/writable = yes/writable = yes\n   create mask = 0644\n   directory mask = 0755/" /etc/samba/smb.conf.default > /etc/samba/smb.conf
paco -p+ $TARGET "touch /etc/samba/smb.conf"

TimeEnd

cd ../..
RemoveSrcDir
PacoingDone

