#!/bin/sh

. ./_blfsset.sh

APPNAME=pulseaudio
VER=4.0
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.xz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	intltool json-c libsndfile \
        pkg-config
. $WRK/_checkOptions.sh  \
	dbus alsa-lib gconf \
        avahi bluez fftw gtk+-2 jack libasyncns lirc openssl \
        orc tdb valgrind webrtc-audio-processing
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

unset MAKEFLAGS

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

groupadd -g 58 pulse
groupadd -g 59 pulse-access
useradd -c 'Pulseaudio User' -d /dev/null -g pulse \
   -s /bin/false -u 58 pulse
usermod -a -G audio pulse

find . -name "Makefile.in" | xargs sed -i "s|(libdir)/@PACKAGE@|(libdir)/pulse|"

Configuring
./configure --prefix=/usr \
            --sysconfdir=/etc \
            --localstatedir=/var \
            --libexecdir=/usr/lib \
            --with-module-dir=/usr/lib/pulse/modules \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p  $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

