#!/bin/sh

. ./_blfsset.sh

APPNAME=openssl
VER=1.0.1f
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  \
	krb5
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

#if [ ${OPTION_krb5} -eq "1" ]; then
#  export WITHKRB5="--with-krb5-flavor=MIT "
#else
#  export WITHKRB5=""
#fi

unset MAKEFLAGS

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Patching
patch -Np1 -i $DLD/openssl-$VER-fix_parallel_build-1.patch \
	1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1
patch -Np1 -i $DLD/openssl-$VER-fix_pod_syntax-1.patch \
	1>> $LOG/$TARGET.0_patch.log 2>&1 || exit 1

Configuring
./config --prefix=/usr         \
         --openssldir=/etc/ssl \
         --libdir=lib          \
         shared                \
         zlib-dynamic          \
         $([ ${OPTION_krb5} -eq "1" ] && echo --with-krb5-flavor=MIT) \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

sed -i 's# libcrypto.a##;s# libssl.a##' Makefile

Installing
paco -p $TARGET "\
make MANDIR=/usr/share/man MANSUFFIX=ssl install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
install -v -d -m755 /usr/share/doc/openssl-$VER" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
cp -vfr doc/*      /usr/share/doc/openssl-$VER" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

