#!/bin/sh

. ./_blfsset.sh

APPNAME=openssl
VER=git
TARGET=$APPNAME-$VER
SRCDIR=/mnt/lfs/sources/git/openssl
BLDDIR=openssl-git

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  \
	bc krb5
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

unset MAKEFLAGS

cd $SRC
mkdir -pv $BLDDIR
cd $BLDDIR

cp -R $SRCDIR/* .

TimeStart

#Patching
#patch -Np1 -i $DLD/openssl-$VER-fix_parallel_build-1.patch \
#	1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1

Configuring
./config --prefix=/usr         \
         --openssldir=/etc/ssl \
         shared                \
         zlib-dynamic          \
         $([ ${OPTION_krb5} -eq "1" ] && echo --with-krb5-flavor=MIT) \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET "\
make MANDIR=/usr/share/man MANSUFFIX=ssl install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
install -v -d -m755 /usr/share/doc/openssl-$VER" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
cp -v -r doc/*      /usr/share/doc/openssl-$VER" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
rm -fr $BLDDIR
PacoingDone

