#!/bin/sh

. ./_blfsset.sh

APPNAME=openldap
VER=2.4.38
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tgz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	db
. $WRK/_checkOptions.sh  \
	openslp tcp_wrappers cyrus-sasl icu \
	unixODBC
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Patching
patch -Np1 -i $DLD/openldap-$VER-blfs_paths-1.patch \
	1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1
patch -Np1 -i $DLD/openldap-$VER-symbol_versions-1.patch \
	1>> $LOG/$TARGET.0_patch.log 2>&1 || exit 1
patch -Np1 -i $DLD/openldap-$VER-ntlm-1.patch \
	1>> $LOG/$TARGET.0_patch.log 2>&1 || exit 1
autoconf \
	1>> $LOG/$TARGET.0_patch.log 2>&1 || exit 1

Configuring
./configure --prefix=/usr \
            --sysconfdir=/etc \
            --localstatedir=/var \
            --libexecdir=/usr/lib \
            --disable-static \
            --disable-debug \
            --enable-dynamic \
            --enable-crypt \
            --enable-modules \
            --enable-rlookups \
            --enable-backends=mod \
            --enable-overlays=mod \
            --disable-ndb \
            --disable-sql \
$([ ${OPTION_openslp} -eq 1 ] && echo --enable-slp) \
$([ ${OPTION_tcp_wrappers} -eq 1 ] && echo --enable-wrappers) \
$([ ${OPTION_cyrussasl} -ne 1 ] && echo --without-cyrus-sasl) \
$([ ${OPTION_cyrussasl} -eq 1 ] && echo --enable-spasswd) \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

echo Making depend...
make depend \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Making
make \
	1>> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p  $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

install -v -dm 755 /usr/share/doc/openldap-$VER

paco -p+ $TARGET "\
cp -vfr doc/drafts /usr/share/doc/openldap-$VER" \
	1>> $LOG/$TARGET.4_install.log 2>&1

paco -p+ $TARGET "\ 
cp -vfr doc/rfc    /usr/share/doc/openldap-$VER" \
	1>> $LOG/$TARGET.4_install.log 2>&1

paco -p+ $TARGET "\
cp -vfr doc/guide  /usr/share/doc/openldap-$VER" \
	1>> $LOG/$TARGET.4_install.log 2>&1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

