#!/bin/sh

. ./_blfsset.sh

APPNAME=neon
VER=0.30.0
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	expat
. $WRK/_checkOptions.sh  \
	openssl libproxy krb5 pakchois
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

#if [ ${OPTION_openssl} -eq "1" ]; then
#  export WITHSSL="--with-ssl=openssl "
#else
#  export WITHSSL=""
#fi

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Configuring
./configure --prefix=/usr --enable-shared \
	$([ ${OPTION_openssl} -eq "1" ] && echo --with-ssl=openssl) \
        --disable-static \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

