#!/bin/sh

. ./_blfsset.sh

APPNAME=libical
VER=0.48
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  \
	python-2 swig
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Configuring
./configure --prefix=/usr --enable-cxx \
	$([ ${OPTION_python2} -eq 1 ] && echo --enable-python) \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1
install -v -m755 -d /usr/share/doc/libical-$VER \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
install -v -m644    README doc/{Adding,Using}*.txt \
                    /usr/share/doc/libical-$VER" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

