#!/bin/sh

. ./_blfsset.sh

APPNAME=gst-plugins-base
APPVER=1
VER=1.0.7
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.xz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	gstreamer-1 libxml2
. $WRK/_checkOptions.sh  \
	alsa-lib gobject-introspection iso-codes \
	libogg libtheora libvorbis pango \
	Xorg-lib-libX11 \
        cdparanoia-III gtk+-3 gtk-doc libvisual orc valgrind 
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Configuring
./configure --prefix=/usr \
            --with-package-name="GStreamer Base Plugins $VER BLFS" \
            --with-package-origin="http://www.linuxfromscratch.org/blfs/view/svn/" \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p  $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

