#!/bin/sh

. ../_blfsset.sh
. ./_gnomeset.sh

APPNAME=nautilus
VER=3.6.3
TARGET=$APPNAME-$VER
TARGETBALL=$GNOMEDLD/$TARGET.tar.xz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh gnome-desktop
. $WRK/_checkOptions.sh  \
	gobject-introspection \
	docbook-utils exempi libexif tracker valgrind \
	gvfs
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

#export CPPFLAGS="-I/usr/include/gtk-2.0 -I/usr/include/gtk-2.0/gdk "
#export LDFLAGS="-L/usr/X11/lib "

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

#echo \ \ Patching...
#patch -Np1 -i $WRK/patch/nautilus-$VER.patch

Configuring
./configure --prefix=/usr \
            --sysconfdir=/etc \
            --libexecdir=/usr/lib/nautilus \
            --disable-nst-extension \
            --disable-packagekit \
            --disable-tracker \
$([ ${OPTION_libexif} -ne 1 ] && echo --enable-libexif=no) \
$([ ${OPTION_exempi} -ne 1 ] && echo --enable-xmp=no) \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

install -v -m755 -d /usr/share/doc/nautilus

paco -p+ $TARGET "\
install -v -m644 docs/*.{txt,dia,pdf,sxw,faq,html} \
        /usr/share/doc/nautilus" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

