#!/bin/sh

. ../_blfsset.sh
. ./_gnomeset.sh

APPNAME=nautilus-sendto
VER=3.6.1
TARGET=$APPNAME-$VER
TARGETBALL=$GNOMEDLD/$TARGET.tar.xz
TARGETDIR=$TARGET

#export CPPFLAGS="-I/usr/include/gtk-2.0 -I/usr/include/gtk-2.0/gdk "
#export LDFLAGS="-L/usr/X11/lib "

echo $TARGET

. $WRK/_checkRequired.sh nautilus
. $WRK/_checkOptions.sh  \
	evolution-data-server gupnp gtk-doc
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Configuring
./configure --prefix=/usr \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

