#!/bin/sh

. ./_blfsset.sh

APPNAME=fop
VER=1.1
TARGET=$APPNAME-$VER
TARGETDIR=$TARGET
TARGETBALL=$DLD/${TARGET}-src.tar.gz

echo $TARGET

. $WRK/_checkRequired.sh apache-ant
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
rm -fr offo-hyphenation
Extract

TimeStart

cd $TARGETDIR

case `uname -m` in
  i?86)
    tar -xf $DLD/jai-1_1_3-lib-linux-i586.tar.gz
    cp -v jai-1_1_3/lib/{jai*,mlibwrapper_jai.jar} $JAVA_HOME/jre/lib/ext/
    cp -v jai-1_1_3/lib/libmlib_jai.so             $JAVA_HOME/jre/lib/i386/
    ;;

  x86_64)
    tar -xf $DLD/jai-1_1_3-lib-linux-amd64.tar.gz
    cp -v jai-1_1_3/lib/{jai*,mlibwrapper_jai.jar} $JAVA_HOME/jre/lib/ext/
    cp -v jai-1_1_3/lib/libmlib_jai.so             $JAVA_HOME/jre/lib/amd64/
    ;;
esac

echo Building \(ant compile\)...
ant compile \
	1> $LOG/$TARGET.1_build.log 2>&1 || (echo Error detected!)
echo Building \(ant jar-main\)...
ant jar-main \
	1>> $LOG/$TARGET.1_build.log 2>&1 || (echo Error detected!)
echo Building \(ant javadocs\)...
ant javadocs \
	1>> $LOG/$TARGET.1_build.log 2>&1 || (echo Error detected!)
mv build/javadocs .

paco -p $TARGET "\
install -v -d -m755                                     /opt/fop-$VER" \
	1> $LOG/$TARGET.2_install.log 2>&1 || (echo Error detected!)

paco -p+ $TARGET "\
cp -v  KEYS LICENSE NOTICE README                       /opt/fop-$VER" \
	1>> $LOG/$TARGET.2_install.log 2>&1 || (echo Error detected!)

paco -p+ $TARGET "\
cp -va build conf examples fop* javadocs lib status.xml /opt/fop-$VER" \
	1>> $LOG/$TARGET.2_install.log 2>&1 || (echo Error detected!)

paco -p+ $TARGET "\
ln -v -sf fop-$VER /opt/fop" \
	1>> $LOG/$TARGET.2_install.log 2>&1 || (echo Error detected!)

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

