#!/bin/sh

. ./_blfsset.sh

APPNAME=colord
VER=1.0.6
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.xz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	glib-2 intltool dbus lcms2 sqlite
. $WRK/_checkOptions.sh  \
	libgusb \
	gobject-introspection polkit \
        vala bash-completion \
	colord-gtk gnome-desktop docbook-utils gtk-doc sane
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

unset MAKEFLAGS

cd $SRC
RemoveSrcDir
Extract

TimeStart

groupadd -g 71 colord &&
useradd -c "Color Daemon Owner" -d /var/lib/colord -u 71 \
        -g colord -s /bin/false colord

cd $TARGETDIR

Configuring
./configure --prefix=/usr \
            --sysconfdir=/etc \
            --libexecdir=/usr/lib/colord \
            --localstatedir=/var \
            --with-daemon-user=colord \
            --disable-static \
	    --disable-systemd-login \
$([ ${OPTION_bashcompletion} -ne 1 ] && echo --disable-bash-completion) \
$([ ${OPTION_vala} -eq 1 ] && echo --enable-vala) \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p  $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

