#!/bin/sh

. ./_blfsset.sh

APPNAME=apache-ant
VER=1.8.4
JUNITVER=4.10
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/${TARGET}-src.tar.bz2
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh openjdk
. $WRK/_checkOptions.sh  junit
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

sed -i 's;jars,test-jar;jars;' build.xml

cp -v /usr/share/junit-$JUNITVER/junit-$JUNITVER.jar \
      lib/optional/junit.jar

paco -p $TARGET "\
./build.sh -Ddist.dir=/opt/ant-$VER dist &&
ln -v -sf ant-$VER /opt/ant" \
	1> $LOG/$TARGET.1_build.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

