#!/bin/sh

. ../_blfsset.sh
. ./_xorgset.sh

APPNAME=xf86-input-evdev
VER=2.8.2
TARGET=$APPNAME-$VER
TARGETBALL=$XORGDLD/$TARGET.tar.bz2
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh xorg-server
. $WRK/_checkOptions.sh  mtdev
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

#    --disable-config-hal \
Configuring
./configure $XORG_CONFIG \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

