#/bin/sh

THISFILE=`basename $0`
CHAP=`echo $THISFILE | sed s/\.sh//`

VER=8.20
TARGET=coreutils-$VER
TARGETBALL=$TARGET.tar.xz
TARGETDIR=$TARGET

echo $CHAP: $TARGET

. ./_lfsset.sh

cd $SRC

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

START=`date +'%Y/%m/%d %H:%M:%S.%N'`

cd $TARGETDIR

sed -i -e 's/! isatty/isatty/' \
       -e '45i\              || errno == ENOENT' gnulib-tests/test-getlogin.c

echo \ \ Patching...
patch -Np1 -i $DLD/coreutils-$VER-i18n-1.patch || exit 1

echo \ \ Configuring...
FORCE_UNSAFE_CONFIGURE=1 ./configure \
            --prefix=/usr         \
            --libexecdir=/usr/lib \
            --enable-no-install-program=kill,uptime \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
paco -p  $TARGET "make install" \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "mv -v /usr/bin/{cat,chgrp,chmod,chown,cp,date,dd,df,echo} /bin" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "mv -v /usr/bin/{false,ln,ls,mkdir,mknod,mv,pwd,rm} /bin" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "mv -v /usr/bin/{rmdir,stty,sync,true,uname} /bin" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "mv -v /usr/bin/chroot /usr/sbin" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "mv -v /usr/share/man/man1/chroot.1 /usr/share/man/man8/chroot.8" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "sed -i s/\"1\"/\"8\"/1 /usr/share/man/man8/chroot.8" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "mv -v /usr/bin/{head,sleep,nice} /bin" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

END=`date +'%Y/%m/%d %H:%M:%S.%N'`

echo $CHAP, $TARGET, $START, $END \
	>> $TME/lfstime.txt

echo \ \ Removing directory...
cd .. && rm -fr $TARGETDIR

echo -n \ \ Pacoing:\   && paco $TARGET || echo none

echo \ \ Done.

