#/bin/sh

THISFILE=`basename $0`
CHAP=`echo $THISFILE | sed s/\.sh//`

VER=3.1.1
TARGET=mpfr-$VER
TARGETBALL=$TARGET.tar.xz
TARGETDIR=$TARGET

echo $CHAP: $TARGET

. ./_lfsset.sh

cd $SRC

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

START=`date +'%Y/%m/%d %H:%M:%S.%N'`

cd $TARGETDIR

#echo \ \ Patching...
#patch -Np1 -i $DLD/mpfr-$VER-fixes-1.patch \
#	1> $LOG/$CHAP.$TARGET.0_patch.log 2>&1 || exit 1

echo \ \ Configuring...
./configure --prefix=/usr --enable-thread-safe \
	--docdir=/usr/share/doc/mpfr-$VER \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

#echo \ \ Checking...
#make check \
#	1> $LOG/$CHAP.$TARGET.3_check.log 2>&1 || echo Error occured in checking

echo \ \ Installing...
paco -p $TARGET "make install" \
	1> $LOG/$CHAP.$TARGET.4_install.log 2>&1 || exit 1

paco -p+ $TARGET "make html" \
	1> $LOG/$CHAP.$TARGET.5_make.log 2>&1 || exit 1

paco -p+ $TARGET "make install-html" \
	1> $LOG/$CHAP.$TARGET.6_install.log 2>&1 || exit 1

END=`date +'%Y/%m/%d %H:%M:%S.%N'`

echo $CHAP, $TARGET, $START, $END \
	>> $TME/lfstime.txt

echo \ \ Removing directory...
cd .. && rm -fr $TARGETDIR

echo \ \ Done.

