#/bin/sh

CHAP=7all

. ./_lfsset.sh

VER=${BOOTSCRIPTVER}
TARGET=lfs-bootscripts-$VER
TARGETBALL=$TARGET.tar.bz2
TARGETDIR=$TARGET

START=`date +'%Y/%m/%d %H:%M:%S.%N'`

echo new 7.2
cd /etc/sysconfig/
cat > ifconfig.eth0 << "EOF"
ONBOOT=yes
IFACE=eth0
SERVICE=ipv4-static
IP=192.168.11.95
GATEWAY=192.168.11.1
PREFIX=24
BROADCAST=192.168.11.255
EOF

echo new 7.2.3
cat > /etc/resolv.conf << "EOF"
# Begin /etc/resolv.conf

domain localdomain
nameserver 192.168.11.1

# End /etc/resolv.conf
EOF

echo new 7.3
if [ $(uname -m) = i686 ]; then
cat > /etc/hosts << "EOF"
# Begin /etc/hosts (network card version)

127.0.0.1 localhost
192.168.11.95 LFS32.localdomain LFS32

# End /etc/hosts (network card version)
EOF
else
cat > /etc/hosts << "EOF"
# Begin /etc/hosts (network card version)

127.0.0.1 localhost
192.168.11.95 LFS64.localdomain LFS64

# End /etc/hosts (network card version)
EOF
fi

echo new 7.6

cd $SRC
rm -fr $TARGETDIR
tar xf $DLD/$TARGETBALL || exit 1
cd $TARGETDIR

echo Installing...
paco -p $TARGET "make install" \
        1> $LOG/$CHAP.$TARGET.1_install.log 2>&1 || exit 1

cd .. && rm -fr $TARGETDIR

echo new 7.7.1

cat > /etc/inittab << "EOF"
# Begin /etc/inittab

id:3:initdefault:

si::sysinit:/etc/rc.d/init.d/rc S

l0:0:wait:/etc/rc.d/init.d/rc 0
l1:S1:wait:/etc/rc.d/init.d/rc 1
l2:2:wait:/etc/rc.d/init.d/rc 2
l3:3:wait:/etc/rc.d/init.d/rc 3
l4:4:wait:/etc/rc.d/init.d/rc 4
l5:5:wait:/etc/rc.d/init.d/rc 5
l6:6:wait:/etc/rc.d/init.d/rc 6

ca:12345:ctrlaltdel:/sbin/shutdown -t1 -a -r now

su:S016:once:/sbin/sulogin

1:2345:respawn:/sbin/agetty --noclear tty1 9600
2:2345:respawn:/sbin/agetty tty2 9600
3:2345:respawn:/sbin/agetty tty3 9600
4:2345:respawn:/sbin/agetty tty4 9600
5:2345:respawn:/sbin/agetty tty5 9600
6:2345:respawn:/sbin/agetty tty6 9600

# End /etc/inittab
EOF

echo new 7.8

if [ $(uname -m) = i686 ]; then
echo "HOSTNAME=LFS32" > /etc/sysconfig/network
else
echo "HOSTNAME=LFS64" > /etc/sysconfig/network
fi

echo new 7.9

cat > /etc/sysconfig/clock << "EOF"
# Begin /etc/sysconfig/clock

UTC=0

# Set this to any options you might need to give to hwclock, 
# such as machine hardware clock type for Alphas.
CLOCKPARAMS=

# End /etc/sysconfig/clock
EOF

echo new 7.10

cat > /etc/sysconfig/console << "EOF"
# Begin /etc/sysconfig/console

UNICODE="1"
KEYMAP="jp106"
FONT=""

# End /etc/sysconfig/console
EOF

echo new 7.13

cat > /etc/profile << "EOF"
# Begin /etc/profile

export LANG=ja_JP.UTF-8

# End /etc/profile
EOF

echo new 7.14

cat > /etc/inputrc << "EOF"
# Begin /etc/inputrc
# Modified by Chris Lynn <roryo@roryo.dynup.net>

# Allow the command prompt to wrap to the next line
set horizontal-scroll-mode Off

# Enable 8bit input
set meta-flag On
set input-meta On

# Turns off 8th bit stripping
set convert-meta Off

# Keep the 8th bit for display
set output-meta On

# none, visible or audible
set bell-style none

# All of the following map the escape sequence of the value
# contained in the 1st argument to the readline specific functions
"\eOd": backward-word
"\eOc": forward-word

# for linux console
"\e[1~": beginning-of-line
"\e[4~": end-of-line
"\e[5~": beginning-of-history
"\e[6~": end-of-history
"\e[3~": delete-char
"\e[2~": quoted-insert

# for xterm
"\eOH": beginning-of-line
"\eOF": end-of-line

# for Konsole
"\e[H": beginning-of-line
"\e[F": end-of-line

# End /etc/inputrc
EOF

