#/bin/sh

THISFILE=`basename $0`
CHAP=`echo $THISFILE | sed s/\.sh//`

APPNAME=gawk
VER=4.1.0
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.xz
TARGETDIR=$TARGET

echo $CHAP: $TARGET

. ./_lfsset.sh

cd $SRC

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

TimeStart

cd $TARGETDIR

echo \ \ Configuring...
./configure --prefix=/usr \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1

echo \ \ Making...
make \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1

echo \ \ Installing...
paco -p $TARGET "make install" \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1

mkdir -v /usr/share/doc/gawk-$VER \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1
paco -p+ $TARGET "\
cp    -v doc/{awkforai.txt,*.{eps,pdf,jpg}} /usr/share/doc/gawk-4.1.0" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1

TimeEnd chap6

echo -n \ \ Pacoing:\   && paco $TARGET || echo none

echo \ \ Removing directory...
cd .. && rm -fr $TARGETDIR

echo \ \ Done.

