#/bin/sh

THISFILE=`basename $0`
CHAP=`echo $THISFILE | sed s/\.sh//`

APPNAME=iana-etc
VER=2.30
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.bz2
TARGETDIR=$TARGET

echo $CHAP: $TARGET

. ./_lfsset.sh

cd $SRC

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

TimeStart

cd $TARGETDIR

echo \ \ Making...
make \
	1> $LOG/$CHAP.$TARGET.1_make.log 2>&1 || exit 1

echo \ \ Installing...
paco -p $TARGET "make install" \
	1> $LOG/$CHAP.$TARGET.2_install.log 2>&1 || exit 1

TimeEnd chap6

echo \ \ Removing directory...
cd .. && rm -fr $TARGETDIR

echo -n \ \ Pacoing:\   && paco $TARGET || echo none

echo \ \ Done.

