#/bin/sh

THISFILE=`basename $0`
CHAP=`echo $THISFILE | sed s/\.sh//`

APPNAME=attr
VER=2.4.47
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.src.tar.gz
TARGETDIR=$TARGET

echo $CHAP: $TARGET

. ./_lfsset.sh

cd $SRC

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

TimeStart

cd $TARGETDIR

sed -i -e 's|/@pkg_name@|&-@pkg_version@|' include/builddefs.in

echo \ \ Configuring...
./configure --prefix=/usr --bindir=/bin \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
paco -p $TARGET "\
make install install-dev install-lib" \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
chmod -v 755 /usr/lib/libattr.so

paco -p $TARGET "\
mv -v /usr/lib/libattr.so.* /lib" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
paco -p $TARGET "\
ln -sfv ../../lib/$(readlink /usr/lib/libattr.so) /usr/lib/libattr.so" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

TimeEnd chap6

echo -n \ \ Pacoing:\   && paco $TARGET || echo none

echo \ \ Removing directory...
cd .. && rm -fr $TARGETDIR

echo \ \ Done.

